using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for PagingListView.
	/// </summary>
	public class PagingListView : System.Windows.Forms.ListView
	{
		private const int WM_HSCROLL = 0x114;
		private const int WM_VSCROLL = 0x115;
		/// <summary>
		/// Horizontal scroll position has changed event
		/// </summary>
		public event ScrollEventHandler HorzScrollValueChanged;

		/// <summary>
		/// Vertical scroll position has changed event
		/// </summary>
		public event ScrollEventHandler VertScrollValueChanged;

		/// <summary>
		/// List view is accepting more data
		/// </summary>
		public event EventHandler MoreDataRequired;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private int _pageLoadCount;

		/// <summary>
		/// Constructor
		/// </summary>
		public PagingListView()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// PagingListView
			// 
			this.FullRowSelect = true;
			this.View = System.Windows.Forms.View.Details;

		}
		#endregion

		/// <summary>
		/// VisibleItems
		/// </summary>
		public int VisibleItems
		{
			get
			{
				if (this.Items.Count == 0)
				{
					return 0;
				}
				return (int)(this.ClientRectangle.Height / this.Items[0].Bounds.Height)-1;
			}
		}

		/// <summary>
		/// The number of items to load per page
		/// </summary>
		[
		Category("Appearance"),
		Description("The number of items to load per page"),
		DefaultValue(50),
		Bindable(true),
		Browsable(true),
		]
		public int PageLoadCount
		{
			get
			{
				return _pageLoadCount;
			}
			set
			{
				_pageLoadCount = value;
			}
		}

		/// <summary>
		/// Determines type of message and calls appropriate Event
		/// </summary>
		/// <param name="m"></param>
		protected override void WndProc(ref Message m)
		{
			// Let the control process the message
			base.WndProc (ref m);

			// Was this a horizontal scroll message?
			if ( m.Msg == WM_HSCROLL ) 
			{
				if ( HorzScrollValueChanged != null ) 
				{
					uint wParam = (uint)m.WParam.ToInt32();
					HorzScrollValueChanged( this, 
						new ScrollEventArgs( 
						GetEventType( wParam & 0xffff), (int)(wParam >> 16) ) );
				}
			} 
				// or a vertical scroll message?
			else if ( m.Msg == WM_VSCROLL )
			{
				uint wParam = (uint)m.WParam.ToInt32();
				OnVertScrollValueChanged(new ScrollEventArgs( GetEventType( wParam & 0xffff), (int)(wParam >> 16) ) );
			}
		}

		/// <summary>
		/// Based on SB_* constants
		/// </summary>
		private static ScrollEventType [] _events =
			new ScrollEventType[] {
									  ScrollEventType.SmallDecrement,
									  ScrollEventType.SmallIncrement,
									  ScrollEventType.LargeDecrement,
									  ScrollEventType.LargeIncrement,
									  ScrollEventType.ThumbPosition,
									  ScrollEventType.ThumbTrack,
									  ScrollEventType.First,
									  ScrollEventType.Last,
									  ScrollEventType.EndScroll
								  };
		/// <summary>
		/// Decode the type of scroll message
		/// </summary>
		/// <param name="wParam">Lower word of scroll notification</param>
		/// <returns></returns>
		private ScrollEventType GetEventType( uint wParam )
		{
			if ( wParam < _events.Length )
				return _events[wParam];
			else
				return ScrollEventType.EndScroll;
		}

		/// <summary>
		/// Vertical Scroll Value Changed Event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnVertScrollValueChanged(ScrollEventArgs e)
		{
			if(VertScrollValueChanged != null)
				VertScrollValueChanged(this, e);
			//
			if ((e.Type == ScrollEventType.EndScroll)||(e.Type == ScrollEventType.LargeIncrement)||(e.Type == ScrollEventType.SmallIncrement))
			{
				if (this.TopItem.Index > this.Items.Count-(this.VisibleItems+2))
				{
					OnMoreDataRequired(EventArgs.Empty);
				}
			}
		}

		/// <summary>
		/// More Date Req'd Event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnMoreDataRequired(EventArgs e)
		{
			if(MoreDataRequired != null)
				MoreDataRequired(this, e);
		}

	}
}
